<?php $__env->startSection('content'); ?>
<div class="col-lg-12 col-xl-12 animated fadeIn">
    <?php echo $__env->make('admin.app.partials.navigations',['navigationTitle' => 'Setup Shortcut Menu'], \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>
    <div class="block block-bordered">
        <div class="block-content">
            <div class="row">
                <div class="col-lg-3">
                    <h2 class="content-heading">Slider Image Configurations
                        <div>
                            <small class="text-muted">
                               Setup slider images.
                            </small>
                        </div>
                    </h2>
                </div>
                <div class="col-lg-9">
                    <div id="admin-setup-slider">
                    </div>
                    <div class="form-group">
                        <label htmlFor="app_link"> Image sliders</label>
                        <table id="image-sliders" class="table table-striped ">
                            <thead>
                                <tr>
                                    <th width="">Image</th>
                                    <th width="">Link</th>
                                    <th width="180">Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php if(isset($sliders)): ?>
                                <?php $__currentLoopData = $sliders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $slider): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr data-sliderId="<?php echo e($slider['id']); ?>">
                                        <td>
                                            <img src="<?php echo e($slider['image_url']); ?>" class="img-responsive" width="50"/>
                                        </td>
                                        <td>
                                            <span><?php echo e(str_limit($slider['link'], 50)); ?></span>
                                        </td>
                                        <td>
                                            
                                            <button type="button" class="btn btn-sm btn-danger mb-2 btndelete">
                                                <i class="fa fa-trash">
                                                </i>
                                            </button>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                <?php else: ?>

                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>


<?php $__env->stopSection(); ?>



<?php $__env->startPush('stylesheet'); ?>
    <style>
        .dropzone {
            flex: 1;
            display: flex;
            flex-direction: column;
            align-items: center;
            padding: 15px;
            border-width: 2px;
            border-radius: 2px;
            border-color: #eeeeee;
            border-style: dashed;
            background-color: #fafafa;
            color: #bdbdbd;
            outline: none;
            transition: border .24s ease-in-out;
        }
    </style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('javascript'); ?>

<script>
    $(document).ready(function(){

        window.dcmUri = (window.dcmUri || {});
        window.dcmUri = {
            resource: '<?php echo route("dcm-setup-slider-resource.store"); ?>',
        };

        $('#image-sliders').on('click','.btndelete',function(){

            var that = this;
            var tbleId =  $(this).parents('tr').data('sliderid');
            axios.delete( window.dcmUri['resource'] + '/' + tbleId)
            .then(function (response) {
                $(that).parents('tr').remove();
            })
            .catch(function (error) {
                console.log(error);
            });
        });
    });
</script>
<script src="<?php echo e(mix('js/admin-setup-slider.js')); ?>"></script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make( "layouts.master-admin", \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>